function [ w,rq,sq ] = quadset( n )
%For input many sample points, outputs necessary weights and bary samples.
%   Only certain prefixed values of n are allowed as preprogrammed below.
%   Careful.  When comes time to integrate, a Jacobian factor of (b-a)/2
%   must also be included in the formula per (1.62) of Schumaker. All are
%   output as column vectors.

if n == 6 %Integrates polynomials up to degree 11.
    %Barycentric Coordinates
    rq = [.966234757, .830604693, .619309593, ...
         .380690407, .169395307, .033765243]';
    sq = 1-rq;
    %Weights
    w  = [.171324492, .360761573, .467913935,...
          .467913935, .360761573, .171324492]';
end


end

